#include <stdlib.h>

#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define IMAGE_FILE "/usr/target/test.png"

int main (int argc, char *argv[])
{
	GdkPixbuf *pixbuf;
	GError *error = NULL;

	pixbuf = gdk_pixbuf_new_from_file (IMAGE_FILE, &error);
	if (pixbuf == NULL)
	{
		g_print ("Error:\t%s\n", error->message);
		g_error_free (error);
		error = NULL;
		return EXIT_FAILURE;
	}

	g_print ("Width:\t%d\n", gdk_pixbuf_get_width (pixbuf));
	g_print ("Height:\t%d\n", gdk_pixbuf_get_height (pixbuf));

	return EXIT_SUCCESS;
}
