/*
 * This file is part of the WebKit open source project.
 * This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebDOMTestEventTarget.h"

#include "Event.h"
#include "KURL.h"
#include "Node.h"
#include "TestEventTarget.h"
#include "WebDOMEvent.h"
#include "WebDOMNode.h"
#include "WebDOMString.h"
#include "WebExceptionHandler.h"
#include "WebNativeEventListener.h"
#include "wtf/text/AtomicString.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

WebDOMTestEventTarget::WebDOMTestEventTarget()
    : WebDOMEventTarget()
{
}

WebDOMTestEventTarget::WebDOMTestEventTarget(WebCore::TestEventTarget* impl)
    : WebDOMEventTarget(impl)
{
}

WebCore::TestEventTarget* WebDOMTestEventTarget::impl() const
{
    return static_cast<WebCore::TestEventTarget*>(WebDOMEventTarget::impl());
}

WebDOMNode WebDOMTestEventTarget::item(unsigned index)
{
    if (!impl())
        return WebDOMNode();

    return toWebKit(WTF::getPtr(impl()->item(index)));
}

void WebDOMTestEventTarget::addEventListener(const WebDOMString& type, const WebDOMEventListener& listener, bool useCapture)
{
    if (!impl())
        return;

    impl()->addEventListener(type, toWebCore(listener), useCapture);
}

void WebDOMTestEventTarget::removeEventListener(const WebDOMString& type, const WebDOMEventListener& listener, bool useCapture)
{
    if (!impl())
        return;

    impl()->removeEventListener(type, toWebCore(listener), useCapture);
}

bool WebDOMTestEventTarget::dispatchEvent(const WebDOMEvent& evt)
{
    if (!impl())
        return false;

    WebCore::ExceptionCode ec = 0;
    bool result = impl()->dispatchEvent(toWebCore(evt), ec);
    webDOMRaiseError(static_cast<WebDOMExceptionCode>(ec));
    return result;
}

WebCore::TestEventTarget* toWebCore(const WebDOMTestEventTarget& wrapper)
{
    return wrapper.impl();
}

WebDOMTestEventTarget toWebKit(WebCore::TestEventTarget* value)
{
    return WebDOMTestEventTarget(value);
}
