/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <glib-object.h>
#include "config.h"

#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>
#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "TestCustomNamedGetter.h"
#include "WebKitDOMBinding.h"
#include "gobject/ConvertToUTF8String.h"
#include "webkit/WebKitDOMTestCustomNamedGetter.h"
#include "webkit/WebKitDOMTestCustomNamedGetterPrivate.h"
#include "webkitdefines.h"
#include "webkitglobalsprivate.h"
#include "webkitmarshal.h"

namespace WebKit {
    
WebKitDOMTestCustomNamedGetter* kit(WebCore::TestCustomNamedGetter* obj)
{
    g_return_val_if_fail(obj, 0);

    if (gpointer ret = DOMObjectCache::get(obj))
        return static_cast<WebKitDOMTestCustomNamedGetter*>(ret);

    return static_cast<WebKitDOMTestCustomNamedGetter*>(DOMObjectCache::put(obj, WebKit::wrapTestCustomNamedGetter(obj)));
}
    
} // namespace WebKit //

void
webkit_dom_test_custom_named_getter_another_function(WebKitDOMTestCustomNamedGetter* self, const gchar* str)
{
    g_return_if_fail(self);
    WebCore::JSMainThreadNullState state;
    WebCore::TestCustomNamedGetter * item = WebKit::core(self);
    g_return_if_fail(str);
    WTF::String converted_str = WTF::String::fromUTF8(str);
    item->anotherFunction(converted_str);
}


G_DEFINE_TYPE(WebKitDOMTestCustomNamedGetter, webkit_dom_test_custom_named_getter, WEBKIT_TYPE_DOM_OBJECT)

namespace WebKit {

WebCore::TestCustomNamedGetter* core(WebKitDOMTestCustomNamedGetter* request)
{
    g_return_val_if_fail(request, 0);

    WebCore::TestCustomNamedGetter* coreObject = static_cast<WebCore::TestCustomNamedGetter*>(WEBKIT_DOM_OBJECT(request)->coreObject);
    g_return_val_if_fail(coreObject, 0);

    return coreObject;
}

} // namespace WebKit
enum {
    PROP_0,
};


static void webkit_dom_test_custom_named_getter_finalize(GObject* object)
{
    WebKitDOMObject* dom_object = WEBKIT_DOM_OBJECT(object);
    
    if (dom_object->coreObject) {
        WebCore::TestCustomNamedGetter* coreObject = static_cast<WebCore::TestCustomNamedGetter *>(dom_object->coreObject);

        WebKit::DOMObjectCache::forget(coreObject);
        coreObject->deref();

        dom_object->coreObject = NULL;
    }

    G_OBJECT_CLASS(webkit_dom_test_custom_named_getter_parent_class)->finalize(object);
}

static void webkit_dom_test_custom_named_getter_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    switch (prop_id) {
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
        break;
    }
}


static void webkit_dom_test_custom_named_getter_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    switch (prop_id) {
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
        break;
    }
}


static void webkit_dom_test_custom_named_getter_constructed(GObject* object)
{

    if (G_OBJECT_CLASS(webkit_dom_test_custom_named_getter_parent_class)->constructed)
        G_OBJECT_CLASS(webkit_dom_test_custom_named_getter_parent_class)->constructed(object);
}

static void webkit_dom_test_custom_named_getter_class_init(WebKitDOMTestCustomNamedGetterClass* requestClass)
{
    GObjectClass *gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->finalize = webkit_dom_test_custom_named_getter_finalize;
    gobjectClass->set_property = webkit_dom_test_custom_named_getter_set_property;
    gobjectClass->get_property = webkit_dom_test_custom_named_getter_get_property;
    gobjectClass->constructed = webkit_dom_test_custom_named_getter_constructed;



}

static void webkit_dom_test_custom_named_getter_init(WebKitDOMTestCustomNamedGetter* request)
{
}

namespace WebKit {
WebKitDOMTestCustomNamedGetter* wrapTestCustomNamedGetter(WebCore::TestCustomNamedGetter* coreObject)
{
    g_return_val_if_fail(coreObject, 0);

    /* We call ref() rather than using a C++ smart pointer because we can't store a C++ object
     * in a C-allocated GObject structure.  See the finalize() code for the
     * matching deref().
     */
    coreObject->ref();

    return  WEBKIT_DOM_TEST_CUSTOM_NAMED_GETTER(g_object_new(WEBKIT_TYPE_DOM_TEST_CUSTOM_NAMED_GETTER,
                                               "core-object", coreObject, NULL));
}
} // namespace WebKit
