/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "config.h"
#include "V8TestObj.h"

#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "IDBBindingUtilities.h"
#include "IDBKey.h"
#include "OptionsObject.h"
#include "RuntimeEnabledFeatures.h"
#include "SVGPropertyTearOff.h"
#include "SVGStaticPropertyTearOff.h"
#include "ScriptArguments.h"
#include "ScriptCallStack.h"
#include "ScriptCallStackFactory.h"
#include "SerializedScriptValue.h"
#include "V8Binding.h"
#include "V8BindingMacros.h"
#include "V8BindingState.h"
#include "V8DOMWrapper.h"
#include "V8Document.h"
#include "V8IsolatedContext.h"
#include "V8Proxy.h"
#include "V8SVGDocument.h"
#include "V8SVGPoint.h"
#include "V8TestCallback.h"
#include "V8a.h"
#include "V8any.h"
#include "V8b.h"
#include "V8bool.h"
#include "V8c.h"
#include "V8d.h"
#include "V8e.h"
#include "V8int.h"
#include <wtf/GetPtr.h>
#include <wtf/RefCounted.h>
#include <wtf/RefPtr.h>
#include <wtf/UnusedParam.h>
#include <wtf/Vector.h>

#if ENABLE(Condition1)
#include "V8TestObjectA.h"
#endif

#if ENABLE(Condition1) && ENABLE(Condition2)
#include "V8TestObjectB.h"
#endif

#if ENABLE(Condition1) || ENABLE(Condition2)
#include "V8TestObjectC.h"
#endif

namespace WebCore {

WrapperTypeInfo V8TestObj::info = { V8TestObj::GetTemplate, V8TestObj::derefObject, 0, 0 };

namespace TestObjInternal {

template <typename T> void V8_USE(T) { }

static v8::Handle<v8::Value> readOnlyIntAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyIntAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->readOnlyIntAttr());
}

static v8::Handle<v8::Value> readOnlyStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyStringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->readOnlyStringAttr());
}

static v8::Handle<v8::Value> readOnlyTestObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyTestObjAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<TestObj> result = imp->readOnlyTestObjAttr();
    v8::Handle<v8::Value> wrapper = result.get() ? V8TestObj::existingWrapper(result.get()) : v8::Handle<v8::Object>();
    if (wrapper.IsEmpty()) {
        wrapper = toV8(result.get());
        if (!wrapper.IsEmpty())
            V8DOMWrapper::setNamedHiddenReference(info.Holder(), "readOnlyTestObjAttr", wrapper);
    }
    return wrapper;
}

static v8::Handle<v8::Value> shortAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.shortAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->shortAttr());
}

static void shortAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.shortAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setShortAttr(v);
    return;
}

static v8::Handle<v8::Value> unsignedShortAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedShortAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->unsignedShortAttr());
}

static void unsignedShortAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedShortAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toUInt32(value);
    imp->setUnsignedShortAttr(v);
    return;
}

static v8::Handle<v8::Value> intAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.intAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->intAttr());
}

static void intAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.intAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setIntAttr(v);
    return;
}

static v8::Handle<v8::Value> longLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.longLongAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->longLongAttr()));
}

static void longLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.longLongAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    long long v = toInt64(value);
    imp->setLongLongAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> unsignedLongLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedLongLongAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->unsignedLongLongAttr()));
}

static void unsignedLongLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedLongLongAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    unsigned long long v = toInt64(value);
    imp->setUnsignedLongLongAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> stringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->stringAttr());
}

static void stringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK_VOID(V8Parameter<>, v, value);
    imp->setStringAttr(v);
    return;
}

static v8::Handle<v8::Value> testObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.testObjAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(imp->testObjAttr());
}

static void testObjAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.testObjAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setTestObjAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> XMLObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.XMLObjAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(imp->xmlObjAttr());
}

static void XMLObjAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.XMLObjAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setXMLObjAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> createAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.create._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->isCreate());
}

static void createAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.create._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool v = value->BooleanValue();
    imp->setCreate(v);
    return;
}

static v8::Handle<v8::Value> reflectedStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedStringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getAttribute(WebCore::HTMLNames::reflectedstringattrAttr));
}

static void reflectedStringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedStringAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK_VOID(V8Parameter<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::reflectedstringattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedIntegralAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->getIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr));
}

static void reflectedIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedIntegralAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedUnsignedIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedUnsignedIntegralAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::NewFromUnsigned(std::max(0, imp->getIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr)));
}

static void reflectedUnsignedIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedUnsignedIntegralAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    unsigned v = toUInt32(value);
    imp->setUnsignedIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedBooleanAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedBooleanAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->hasAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr));
}

static void reflectedBooleanAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedBooleanAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool v = value->BooleanValue();
    imp->setBooleanAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedURLAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedURLAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getURLAttribute(WebCore::HTMLNames::reflectedurlattrAttr));
}

static void reflectedURLAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedURLAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK_VOID(V8Parameter<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::reflectedurlattrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedStringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getAttribute(WebCore::HTMLNames::customContentStringAttrAttr));
}

static void reflectedStringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedStringAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK_VOID(V8Parameter<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::customContentStringAttrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedCustomIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomIntegralAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->getIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr));
}

static void reflectedCustomIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomIntegralAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedCustomBooleanAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomBooleanAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->hasAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr));
}

static void reflectedCustomBooleanAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomBooleanAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool v = value->BooleanValue();
    imp->setBooleanAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr, v);
    return;
}

static v8::Handle<v8::Value> reflectedCustomURLAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomURLAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getURLAttribute(WebCore::HTMLNames::customContentURLAttrAttr));
}

static void reflectedCustomURLAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.reflectedCustomURLAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK_VOID(V8Parameter<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::customContentURLAttrAttr, v);
    return;
}

static v8::Handle<v8::Value> attrWithGetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithGetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    int v = imp->attrWithGetterException(ec);
    if (UNLIKELY(ec)) {
        V8Proxy::setDOMException(ec);
        return v8::Handle<v8::Value>();
    }
    return v8::Integer::New(v);
}

static void attrWithGetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithGetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    ExceptionCode ec = 0;
    imp->setAttrWithGetterException(v, ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    return;
}

static v8::Handle<v8::Value> attrWithSetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithSetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->attrWithSetterException());
}

static void attrWithSetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithSetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    ExceptionCode ec = 0;
    imp->setAttrWithSetterException(v, ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    return;
}

static v8::Handle<v8::Value> stringAttrWithGetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttrWithGetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    String v = imp->stringAttrWithGetterException(ec);
    if (UNLIKELY(ec)) {
        V8Proxy::setDOMException(ec);
        return v8::Handle<v8::Value>();
    }
    return v8String(v);
}

static void stringAttrWithGetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttrWithGetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK_VOID(V8Parameter<>, v, value);
    ExceptionCode ec = 0;
    imp->setStringAttrWithGetterException(v, ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    return;
}

static v8::Handle<v8::Value> stringAttrWithSetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttrWithSetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->stringAttrWithSetterException());
}

static void stringAttrWithSetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttrWithSetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK_VOID(V8Parameter<>, v, value);
    ExceptionCode ec = 0;
    imp->setStringAttrWithSetterException(v, ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    return;
}

static v8::Handle<v8::Value> withScriptStateAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptStateAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* state = ScriptState::current();
    if (!state)
        return v8::Undefined();
    return v8::Integer::New(imp->withScriptStateAttribute(state));
}

static void withScriptStateAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptStateAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    ScriptState* state = ScriptState::current();
    if (!state)
        return;
    imp->setWithScriptStateAttribute(state, v);
    if (state.hadException())
        throwError(state.exception());
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    return toV8(imp->withScriptExecutionContextAttribute(scriptContext));
}

static void withScriptExecutionContextAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return;
    imp->setWithScriptExecutionContextAttribute(scriptContext, WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> withScriptStateAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptStateAttributeRaises._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptState* state = ScriptState::current();
    if (!state)
        return v8::Undefined();
    RefPtr<TestObj> v = imp->withScriptStateAttributeRaises(state, ec);
    if (UNLIKELY(ec)) {
        V8Proxy::setDOMException(ec);
        return v8::Handle<v8::Value>();
    }
    if (state.hadException())
        return throwError(state.exception());
    return toV8(v.release());
}

static void withScriptStateAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptStateAttributeRaises._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ExceptionCode ec = 0;
    ScriptState* state = ScriptState::current();
    if (!state)
        return;
    imp->setWithScriptStateAttributeRaises(state, WTF::getPtr(v), ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    if (state.hadException())
        throwError(state.exception());
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAttributeRaises._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    RefPtr<TestObj> v = imp->withScriptExecutionContextAttributeRaises(scriptContext, ec);
    if (UNLIKELY(ec)) {
        V8Proxy::setDOMException(ec);
        return v8::Handle<v8::Value>();
    }
    return toV8(v.release());
}

static void withScriptExecutionContextAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAttributeRaises._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return;
    imp->setWithScriptExecutionContextAttributeRaises(scriptContext, WTF::getPtr(v), ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* state = ScriptState::current();
    if (!state)
        return v8::Undefined();
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    return toV8(imp->withScriptExecutionContextAndScriptStateAttribute(state, scriptContext));
}

static void withScriptExecutionContextAndScriptStateAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptState* state = ScriptState::current();
    if (!state)
        return;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return;
    imp->setWithScriptExecutionContextAndScriptStateAttribute(state, scriptContext, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception());
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateAttributeRaises._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptState* state = ScriptState::current();
    if (!state)
        return v8::Undefined();
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    RefPtr<TestObj> v = imp->withScriptExecutionContextAndScriptStateAttributeRaises(state, scriptContext, ec);
    if (UNLIKELY(ec)) {
        V8Proxy::setDOMException(ec);
        return v8::Handle<v8::Value>();
    }
    if (state.hadException())
        return throwError(state.exception());
    return toV8(v.release());
}

static void withScriptExecutionContextAndScriptStateAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateAttributeRaises._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ExceptionCode ec = 0;
    ScriptState* state = ScriptState::current();
    if (!state)
        return;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return;
    imp->setWithScriptExecutionContextAndScriptStateAttributeRaises(state, scriptContext, WTF::getPtr(v), ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    if (state.hadException())
        throwError(state.exception());
    return;
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateWithSpacesAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* state = ScriptState::current();
    if (!state)
        return v8::Undefined();
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    return toV8(imp->withScriptExecutionContextAndScriptStateWithSpacesAttribute(state, scriptContext));
}

static void withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateWithSpacesAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    ScriptState* state = ScriptState::current();
    if (!state)
        return;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return;
    imp->setWithScriptExecutionContextAndScriptStateWithSpacesAttribute(state, scriptContext, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception());
    return;
}

static v8::Handle<v8::Value> withScriptArgumentsAndCallStackAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptArgumentsAndCallStackAttribute._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<ScriptCallStack> callStack(createScriptCallStackForInspector());
    if (!callStack)
        return v8::Undefined();
    return toV8(imp->withScriptArgumentsAndCallStackAttribute(callStack));
}

static void withScriptArgumentsAndCallStackAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.withScriptArgumentsAndCallStackAttribute._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    RefPtr<ScriptCallStack> callStack(createScriptCallStackForInspector());
    if (!callStack)
        return v8::Undefined();
    imp->setWithScriptArgumentsAndCallStackAttribute(callStack, WTF::getPtr(v));
    return;
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> conditionalAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr1._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->conditionalAttr1());
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static void conditionalAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr1._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setConditionalAttr1(v);
    return;
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1) && ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr2._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->conditionalAttr2());
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) && ENABLE(Condition2)

static void conditionalAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr2._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setConditionalAttr2(v);
    return;
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalAttr3AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr3._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->conditionalAttr3());
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static void conditionalAttr3AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.conditionalAttr3._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setConditionalAttr3(v);
    return;
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> cachedAttribute1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.cachedAttribute1._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<any> result = imp->cachedAttribute1();
    v8::Handle<v8::Value> wrapper = result.get() ? V8any::existingWrapper(result.get()) : v8::Handle<v8::Object>();
    if (wrapper.IsEmpty()) {
        wrapper = toV8(result.get());
        if (!wrapper.IsEmpty())
            V8DOMWrapper::setNamedHiddenReference(info.Holder(), "cachedAttribute1", wrapper);
    }
    return wrapper;
}

static v8::Handle<v8::Value> cachedAttribute2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.cachedAttribute2._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<any> result = imp->cachedAttribute2();
    v8::Handle<v8::Value> wrapper = result.get() ? V8any::existingWrapper(result.get()) : v8::Handle<v8::Object>();
    if (wrapper.IsEmpty()) {
        wrapper = toV8(result.get());
        if (!wrapper.IsEmpty())
            V8DOMWrapper::setNamedHiddenReference(info.Holder(), "cachedAttribute2", wrapper);
    }
    return wrapper;
}

static v8::Handle<v8::Value> enabledAtRuntimeAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeAttr1._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->enabledAtRuntimeAttr1());
}

static void enabledAtRuntimeAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeAttr1._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setEnabledAtRuntimeAttr1(v);
    return;
}

static v8::Handle<v8::Value> enabledAtRuntimeAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeAttr2._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->enabledAtRuntimeAttr2());
}

static void enabledAtRuntimeAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeAttr2._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setEnabledAtRuntimeAttr2(v);
    return;
}

static v8::Handle<v8::Value> floatArrayAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.floatArray._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8NumberArray(imp->floatArray());
}

static void floatArrayAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.floatArray._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    Vector<float> v = v8NumberArrayToVector<float>(value);
    imp->setFloatArray(v);
    return;
}

static v8::Handle<v8::Value> doubleArrayAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.doubleArray._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8NumberArray(imp->doubleArray());
}

static void doubleArrayAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.doubleArray._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    Vector<double> v = v8NumberArrayToVector<double>(value);
    imp->setDoubleArray(v);
    return;
}

static v8::Handle<v8::Value> contentDocumentAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.contentDocument._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    if (!V8BindingSecurity::shouldAllowAccessToNode(V8BindingState::Only(), imp->contentDocument()))
    return v8::Handle<v8::Value>();

    return toV8(imp->contentDocument());
}

static v8::Handle<v8::Value> mutablePointAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.mutablePoint._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(WTF::getPtr(SVGStaticPropertyTearOff<TestObj, FloatPoint>::create(imp, imp->mutablePoint(), &TestObj::updateMutablePoint)));
}

static void mutablePointAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.mutablePoint._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<SVGPropertyTearOff<FloatPoint> > v = V8SVGPoint::HasInstance(value) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setMutablePoint(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> immutablePointAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.immutablePoint._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->immutablePoint())));
}

static void immutablePointAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.immutablePoint._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<SVGPropertyTearOff<FloatPoint> > v = V8SVGPoint::HasInstance(value) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setImmutablePoint(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> strictFloatAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.strictFloat._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(imp->strictFloat());
}

static void strictFloatAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.strictFloat._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    float v = static_cast<float>(value->NumberValue());
    imp->setStrictFloat(v);
    return;
}

static v8::Handle<v8::Value> descriptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.description._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->description());
}

static v8::Handle<v8::Value> idAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.id._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->id());
}

static void idAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.id._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setId(v);
    return;
}

static v8::Handle<v8::Value> hashAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.hash._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->hash());
}

static v8::Handle<v8::Value> TestObjConstructorGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.constructors._get");
    v8::Handle<v8::Value> data = info.Data();
    ASSERT(data->IsExternal() || data->IsNumber());
    WrapperTypeInfo* type = WrapperTypeInfo::unwrap(data);
    return v8::Handle<v8::Value>();}

static v8::Handle<v8::Value> voidMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.voidMethod");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->voidMethod();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> voidMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.voidMethodWithArgs");
    if (args.Length() < 3)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, intArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, strArg, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    EXCEPTION_BLOCK(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined))) : 0);
    imp->voidMethodWithArgs(intArg, strArg, objArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> intMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.intMethod");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return v8::Integer::New(imp->intMethod());
}

static v8::Handle<v8::Value> intMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.intMethodWithArgs");
    if (args.Length() < 3)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, intArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, strArg, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    EXCEPTION_BLOCK(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined))) : 0);
    return v8::Integer::New(imp->intMethodWithArgs(intArg, strArg, objArg));
}

static v8::Handle<v8::Value> objMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.objMethod");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(imp->objMethod());
}

static v8::Handle<v8::Value> objMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.objMethodWithArgs");
    if (args.Length() < 3)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, intArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, strArg, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    EXCEPTION_BLOCK(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined))) : 0);
    return toV8(imp->objMethodWithArgs(intArg, strArg, objArg));
}

static v8::Handle<v8::Value> methodThatRequiresAllArgsAndThrowsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodThatRequiresAllArgsAndThrows");
    if (args.Length() < 2)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, strArg, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    EXCEPTION_BLOCK(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined))) : 0);
    RefPtr<TestObj> result = imp->methodThatRequiresAllArgsAndThrows(strArg, objArg, ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release());
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> serializedValueCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.serializedValue");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    bool serializedArgDidThrow = false;
    RefPtr<SerializedScriptValue> serializedArg = SerializedScriptValue::create(args[0], 0, 0, serializedArgDidThrow);
    if (serializedArgDidThrow)
        return v8::Undefined();
    imp->serializedValue(serializedArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> idbKeyCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.idbKey");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(RefPtr<IDBKey>, key, createIDBKeyFromValue(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->idbKey(key.get());
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> optionsObjectCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.optionsObject");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(OptionsObject, oo, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    if (args.Length() > 0 && !oo.isUndefinedOrNull() && !oo.isObject()) {
        ec = TYPE_MISMATCH_ERR;
        V8Proxy::setDOMException(ec);
        return throwError("Not an object.", V8Proxy::TypeError);
    }
    if (args.Length() <= 1) {
        imp->optionsObject(oo);
        return v8::Handle<v8::Value>();
    }
    EXCEPTION_BLOCK(OptionsObject, ooo, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    if (args.Length() > 1 && !ooo.isUndefinedOrNull() && !ooo.isObject()) {
        ec = TYPE_MISMATCH_ERR;
        V8Proxy::setDOMException(ec);
        return throwError("Not an object.", V8Proxy::TypeError);
    }
    imp->optionsObject(oo, ooo);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    imp->methodWithException(ec);
    if (UNLIKELY(ec))
        goto fail;
    return v8::Handle<v8::Value>();
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> addEventListenerCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.addEventListener()");
    RefPtr<EventListener> listener = V8DOMWrapper::getEventListener(args[1], false, ListenerFindOrCreate);
    if (listener) {
        V8TestObj::toNative(args.Holder())->addEventListener(v8ValueToAtomicWebCoreString(args[0]), listener, args[2]->BooleanValue());
        createHiddenDependency(args.Holder(), args[1], V8TestObj::eventListenerCacheIndex);
    }
    return v8::Undefined();
}

static v8::Handle<v8::Value> removeEventListenerCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.removeEventListener()");
    RefPtr<EventListener> listener = V8DOMWrapper::getEventListener(args[1], false, ListenerFindOnly);
    if (listener) {
        V8TestObj::toNative(args.Holder())->removeEventListener(v8ValueToAtomicWebCoreString(args[0]), listener.get(), args[2]->BooleanValue());
        removeHiddenDependency(args.Holder(), args[1], V8TestObj::eventListenerCacheIndex);
    }
    return v8::Undefined();
}

static v8::Handle<v8::Value> withScriptStateVoidCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateVoid");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EmptyScriptState state;
    imp->withScriptStateVoid(&state);
    if (state.hadException())
        return throwError(state.exception());
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptStateObjCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateObj");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EmptyScriptState state;
    RefPtr<TestObj> result = imp->withScriptStateObj(&state);
    if (state.hadException())
        return throwError(state.exception());
    return toV8(result.release());
}

static v8::Handle<v8::Value> withScriptStateVoidExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateVoidException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    EmptyScriptState state;
    imp->withScriptStateVoidException(&state, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException())
        return throwError(state.exception());
    return v8::Handle<v8::Value>();
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptStateObjExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateObjException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    EmptyScriptState state;
    RefPtr<TestObj> result = imp->withScriptStateObjException(&state, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException())
        return throwError(state.exception());
    return toV8(result.release());
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptExecutionContextCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContext");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    imp->withScriptExecutionContext(scriptContext);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptState");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EmptyScriptState state;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    imp->withScriptExecutionContextAndScriptState(&state, scriptContext);
    if (state.hadException())
        return throwError(state.exception());
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateObjExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateObjException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    EmptyScriptState state;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    RefPtr<TestObj> result = imp->withScriptExecutionContextAndScriptStateObjException(&state, scriptContext, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException())
        return throwError(state.exception());
    return toV8(result.release());
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateWithSpacesCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContextAndScriptStateWithSpaces");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EmptyScriptState state;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    RefPtr<TestObj> result = imp->withScriptExecutionContextAndScriptStateWithSpaces(&state, scriptContext);
    if (state.hadException())
        return throwError(state.exception());
    return toV8(result.release());
}

static v8::Handle<v8::Value> withScriptArgumentsAndCallStackCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptArgumentsAndCallStack");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    RefPtr<ScriptArguments> scriptArguments(createScriptArguments(args, 0));
    RefPtr<ScriptCallStack> callStack(createScriptCallStackForInspector());
    if (!callStack)
        return v8::Undefined();
    imp->withScriptArgumentsAndCallStack(scriptArguments, callStack);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalArg");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0) {
        imp->methodWithOptionalArg();
        return v8::Handle<v8::Value>();
    }
    EXCEPTION_BLOCK(int, opt, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->methodWithOptionalArg(opt);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithNonOptionalArgAndOptionalArg");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, nonOpt, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    if (args.Length() <= 1) {
        imp->methodWithNonOptionalArgAndOptionalArg(nonOpt);
        return v8::Handle<v8::Value>();
    }
    EXCEPTION_BLOCK(int, opt, toInt32(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)));
    imp->methodWithNonOptionalArgAndOptionalArg(nonOpt, opt);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndTwoOptionalArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithNonOptionalArgAndTwoOptionalArgs");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, nonOpt, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    if (args.Length() <= 1) {
        imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt);
        return v8::Handle<v8::Value>();
    }
    EXCEPTION_BLOCK(int, opt1, toInt32(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)));
    if (args.Length() <= 2) {
        imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1);
        return v8::Handle<v8::Value>();
    }
    EXCEPTION_BLOCK(int, opt2, toInt32(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)));
    imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1, opt2);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithOptionalStringCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalString");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0) {
        imp->methodWithOptionalString();
        return v8::Handle<v8::Value>();
    }
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, str, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    imp->methodWithOptionalString(str);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithOptionalStringIsUndefinedCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalStringIsUndefined");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, str, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    imp->methodWithOptionalStringIsUndefined(str);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithOptionalStringIsNullStringCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalStringIsNullString");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, str, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsNullString));
    imp->methodWithOptionalStringIsNullString(str);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithCallbackArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithCallbackArg");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0 || !args[0]->IsObject())
        return throwError(TYPE_MISMATCH_ERR);
    RefPtr<TestCallback> callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    imp->methodWithCallbackArg(callback);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithNonCallbackArgAndCallbackArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithNonCallbackArgAndCallbackArg");
    if (args.Length() < 2)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, nonCallback, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    if (args.Length() <= 1 || !args[1]->IsObject())
        return throwError(TYPE_MISMATCH_ERR);
    RefPtr<TestCallback> callback = V8TestCallback::create(args[1], getScriptExecutionContext());
    imp->methodWithNonCallbackArgAndCallbackArg(nonCallback, callback);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithCallbackAndOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithCallbackAndOptionalArg");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    RefPtr<TestCallback> callback;
    if (args.Length() > 0 && !args[0]->IsNull() && !args[0]->IsUndefined()) {
        if (!args[0]->IsObject())
            return throwError(TYPE_MISMATCH_ERR);
        callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    }
    imp->methodWithCallbackAndOptionalArg(callback);
    return v8::Handle<v8::Value>();
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> conditionalMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.conditionalMethod1");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return v8String(imp->conditionalMethod1());
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1) && ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalMethod2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.conditionalMethod2");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->conditionalMethod2();
    return v8::Handle<v8::Value>();
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalMethod3Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.conditionalMethod3");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->conditionalMethod3();
    return v8::Handle<v8::Value>();
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> overloadedMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod1");
    if (args.Length() < 2)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, strArg, MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined));
    imp->overloadedMethod(objArg, strArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod2");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(TestObj*, objArg, V8TestObj::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    if (args.Length() <= 1) {
        imp->overloadedMethod(objArg);
        return v8::Handle<v8::Value>();
    }
    EXCEPTION_BLOCK(int, intArg, toInt32(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)));
    imp->overloadedMethod(objArg, intArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod3Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod3");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, strArg, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    imp->overloadedMethod(strArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod4Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod4");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, intArg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->overloadedMethod(intArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod5Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod5");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0 || !args[0]->IsObject())
        return throwError(TYPE_MISMATCH_ERR);
    RefPtr<TestCallback> callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    imp->overloadedMethod(callback);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod6Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod6");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(RefPtr<DOMStringList>, listArg, v8ValueToWebCoreDOMStringList(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->overloadedMethod(listArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod7Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod7");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(RefPtr<DOMStringList>, arrayArg, v8ValueToWebCoreDOMStringList(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    imp->overloadedMethod(arrayArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod");
    if ((args.Length() == 2 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0])) && (args[1]->IsNull() || args[1]->IsUndefined() || args[1]->IsString() || args[1]->IsObject())))
        return overloadedMethod1Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0]))) || (args.Length() == 2 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0]))))
        return overloadedMethod2Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsUndefined() || args[0]->IsString() || args[0]->IsObject())))
        return overloadedMethod3Callback(args);
    if (args.Length() == 1)
        return overloadedMethod4Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsObject())))
        return overloadedMethod5Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || V8DOMStringList::HasInstance(args[0]))))
        return overloadedMethod6Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsArray())))
        return overloadedMethod7Callback(args);
    V8Proxy::throwTypeError();
    return notHandledByInterceptor();
}

static v8::Handle<v8::Value> classMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.classMethod");
    TestObj::classMethod();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> classMethodWithOptionalCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.classMethodWithOptional");
    if (args.Length() <= 0) {
        return v8::Integer::New(TestObj::classMethodWithOptional());
    }
    EXCEPTION_BLOCK(int, arg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    return v8::Integer::New(TestObj::classMethodWithOptional(arg));
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod11Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod11");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    EXCEPTION_BLOCK(int, arg, toInt32(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)));
    TestObj::overloadedMethod1(arg);
    return v8::Handle<v8::Value>();
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod12Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod12");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, type, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    TestObj::overloadedMethod1(type);
    return v8::Handle<v8::Value>();
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod1");
    if (args.Length() == 1)
        return overloadedMethod11Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsUndefined() || args[0]->IsString() || args[0]->IsObject())))
        return overloadedMethod12Callback(args);
    V8Proxy::throwTypeError();
    return notHandledByInterceptor();
}

#endif // ENABLE(Condition1)

static v8::Handle<v8::Value> enabledAtRuntimeMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeMethod1");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, intArg, V8int::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8int::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->enabledAtRuntimeMethod1(intArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> enabledAtRuntimeMethod2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.enabledAtRuntimeMethod2");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(int, intArg, V8int::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8int::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->enabledAtRuntimeMethod2(intArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> getSVGDocumentCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.getSVGDocument");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    if (!V8BindingSecurity::shouldAllowAccessToNode(V8BindingState::Only(), imp->getSVGDocument(ec)))
        return v8::Handle<v8::Value>();
    RefPtr<SVGDocument> result = imp->getSVGDocument(ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release());
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> convert1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert1");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(a*, , V8a::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8a::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert1();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> convert2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert2");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(b*, , V8b::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8b::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert2();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> convert3Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert3");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(c*, , V8c::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8c::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert3();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> convert4Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert4");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(d*, , V8d::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8d::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert4();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> convert5Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.convert5");
    if (args.Length() < 1)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EXCEPTION_BLOCK(e*, , V8e::HasInstance(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined)) ? V8e::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined))) : 0);
    imp->convert5();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> mutablePointFunctionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.mutablePointFunction");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->mutablePointFunction())));
}

static v8::Handle<v8::Value> immutablePointFunctionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.immutablePointFunction");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->immutablePointFunction())));
}

static v8::Handle<v8::Value> orangeCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.orange");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->banana();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> strictFunctionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.strictFunction");
    if (args.Length() < 3)
        return throwError("Not enough arguments", V8Proxy::TypeError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    STRING_TO_V8PARAMETER_EXCEPTION_BLOCK(V8Parameter<>, str, MAYBE_MISSING_PARAMETER(args, 0, DefaultIsUndefined));
    EXCEPTION_BLOCK(float, a, static_cast<float>(MAYBE_MISSING_PARAMETER(args, 1, DefaultIsUndefined)->NumberValue()));
    EXCEPTION_BLOCK(int, b, V8int::HasInstance(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined)) ? V8int::toNative(v8::Handle<v8::Object>::Cast(MAYBE_MISSING_PARAMETER(args, 2, DefaultIsUndefined))) : 0);
    RefPtr<bool> result = imp->strictFunction(str, a, b, ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release());
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

} // namespace TestObjInternal

static const BatchedAttribute TestObjAttrs[] = {
    // Attribute 'readOnlyIntAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyIntAttr", TestObjInternal::readOnlyIntAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyStringAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyStringAttr", TestObjInternal::readOnlyStringAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyTestObjAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyTestObjAttr", TestObjInternal::readOnlyTestObjAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'shortAttr' (Type: 'attribute' ExtAttr: '')
    {"shortAttr", TestObjInternal::shortAttrAttrGetter, TestObjInternal::shortAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'unsignedShortAttr' (Type: 'attribute' ExtAttr: '')
    {"unsignedShortAttr", TestObjInternal::unsignedShortAttrAttrGetter, TestObjInternal::unsignedShortAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'intAttr' (Type: 'attribute' ExtAttr: '')
    {"intAttr", TestObjInternal::intAttrAttrGetter, TestObjInternal::intAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'longLongAttr' (Type: 'attribute' ExtAttr: '')
    {"longLongAttr", TestObjInternal::longLongAttrAttrGetter, TestObjInternal::longLongAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'unsignedLongLongAttr' (Type: 'attribute' ExtAttr: '')
    {"unsignedLongLongAttr", TestObjInternal::unsignedLongLongAttrAttrGetter, TestObjInternal::unsignedLongLongAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttr' (Type: 'attribute' ExtAttr: '')
    {"stringAttr", TestObjInternal::stringAttrAttrGetter, TestObjInternal::stringAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'testObjAttr' (Type: 'attribute' ExtAttr: '')
    {"testObjAttr", TestObjInternal::testObjAttrAttrGetter, TestObjInternal::testObjAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'XMLObjAttr' (Type: 'attribute' ExtAttr: '')
    {"XMLObjAttr", TestObjInternal::XMLObjAttrAttrGetter, TestObjInternal::XMLObjAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'create' (Type: 'attribute' ExtAttr: '')
    {"create", TestObjInternal::createAttrGetter, TestObjInternal::createAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedStringAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedStringAttr", TestObjInternal::reflectedStringAttrAttrGetter, TestObjInternal::reflectedStringAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedIntegralAttr", TestObjInternal::reflectedIntegralAttrAttrGetter, TestObjInternal::reflectedIntegralAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedUnsignedIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedUnsignedIntegralAttr", TestObjInternal::reflectedUnsignedIntegralAttrAttrGetter, TestObjInternal::reflectedUnsignedIntegralAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedBooleanAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedBooleanAttr", TestObjInternal::reflectedBooleanAttrAttrGetter, TestObjInternal::reflectedBooleanAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedURLAttr' (Type: 'attribute' ExtAttr: 'URL Reflect')
    {"reflectedURLAttr", TestObjInternal::reflectedURLAttrAttrGetter, TestObjInternal::reflectedURLAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedStringAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedStringAttr", TestObjInternal::reflectedStringAttrAttrGetter, TestObjInternal::reflectedStringAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedCustomIntegralAttr", TestObjInternal::reflectedCustomIntegralAttrAttrGetter, TestObjInternal::reflectedCustomIntegralAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomBooleanAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedCustomBooleanAttr", TestObjInternal::reflectedCustomBooleanAttrAttrGetter, TestObjInternal::reflectedCustomBooleanAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomURLAttr' (Type: 'attribute' ExtAttr: 'URL Reflect')
    {"reflectedCustomURLAttr", TestObjInternal::reflectedCustomURLAttrAttrGetter, TestObjInternal::reflectedCustomURLAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithGetterException' (Type: 'attribute' ExtAttr: '')
    {"attrWithGetterException", TestObjInternal::attrWithGetterExceptionAttrGetter, TestObjInternal::attrWithGetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithSetterException' (Type: 'attribute' ExtAttr: '')
    {"attrWithSetterException", TestObjInternal::attrWithSetterExceptionAttrGetter, TestObjInternal::attrWithSetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttrWithGetterException' (Type: 'attribute' ExtAttr: '')
    {"stringAttrWithGetterException", TestObjInternal::stringAttrWithGetterExceptionAttrGetter, TestObjInternal::stringAttrWithGetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttrWithSetterException' (Type: 'attribute' ExtAttr: '')
    {"stringAttrWithSetterException", TestObjInternal::stringAttrWithSetterExceptionAttrGetter, TestObjInternal::stringAttrWithSetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'customAttr' (Type: 'attribute' ExtAttr: 'Custom')
    {"customAttr", V8TestObj::customAttrAccessorGetter, V8TestObj::customAttrAccessorSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptStateAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptStateAttribute", TestObjInternal::withScriptStateAttributeAttrGetter, TestObjInternal::withScriptStateAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAttribute", TestObjInternal::withScriptExecutionContextAttributeAttrGetter, TestObjInternal::withScriptExecutionContextAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptStateAttributeRaises' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptStateAttributeRaises", TestObjInternal::withScriptStateAttributeRaisesAttrGetter, TestObjInternal::withScriptStateAttributeRaisesAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAttributeRaises' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAttributeRaises", TestObjInternal::withScriptExecutionContextAttributeRaisesAttrGetter, TestObjInternal::withScriptExecutionContextAttributeRaisesAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAndScriptStateAttribute", TestObjInternal::withScriptExecutionContextAndScriptStateAttributeAttrGetter, TestObjInternal::withScriptExecutionContextAndScriptStateAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateAttributeRaises' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAndScriptStateAttributeRaises", TestObjInternal::withScriptExecutionContextAndScriptStateAttributeRaisesAttrGetter, TestObjInternal::withScriptExecutionContextAndScriptStateAttributeRaisesAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateWithSpacesAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAndScriptStateWithSpacesAttribute", TestObjInternal::withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrGetter, TestObjInternal::withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptArgumentsAndCallStackAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptArgumentsAndCallStackAttribute", TestObjInternal::withScriptArgumentsAndCallStackAttributeAttrGetter, TestObjInternal::withScriptArgumentsAndCallStackAttributeAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#if ENABLE(Condition1)
    // Attribute 'conditionalAttr1' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr1", TestObjInternal::conditionalAttr1AttrGetter, TestObjInternal::conditionalAttr1AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1)
#if ENABLE(Condition1) && ENABLE(Condition2)
    // Attribute 'conditionalAttr2' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr2", TestObjInternal::conditionalAttr2AttrGetter, TestObjInternal::conditionalAttr2AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1) && ENABLE(Condition2)
#if ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'conditionalAttr3' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr3", TestObjInternal::conditionalAttr3AttrGetter, TestObjInternal::conditionalAttr3AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1) || ENABLE(Condition2)
#if ENABLE(Condition1)
    // Attribute 'conditionalAttr4' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr4", TestObjInternal::TestObjConstructorGetter, 0, &V8TestObjectA::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::ReadOnly), 0 /* on instance */},
#endif // ENABLE(Condition1)
#if ENABLE(Condition1) && ENABLE(Condition2)
    // Attribute 'conditionalAttr5' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr5", TestObjInternal::TestObjConstructorGetter, 0, &V8TestObjectB::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::ReadOnly), 0 /* on instance */},
#endif // ENABLE(Condition1) && ENABLE(Condition2)
#if ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'conditionalAttr6' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr6", TestObjInternal::TestObjConstructorGetter, 0, &V8TestObjectC::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::ReadOnly), 0 /* on instance */},
#endif // ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'cachedAttribute1' (Type: 'readonly attribute' ExtAttr: 'CachedAttribute')
    {"cachedAttribute1", TestObjInternal::cachedAttribute1AttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'cachedAttribute2' (Type: 'readonly attribute' ExtAttr: 'CachedAttribute')
    {"cachedAttribute2", TestObjInternal::cachedAttribute2AttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'floatArray' (Type: 'attribute' ExtAttr: '')
    {"floatArray", TestObjInternal::floatArrayAttrGetter, TestObjInternal::floatArrayAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'doubleArray' (Type: 'attribute' ExtAttr: '')
    {"doubleArray", TestObjInternal::doubleArrayAttrGetter, TestObjInternal::doubleArrayAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'contentDocument' (Type: 'readonly attribute' ExtAttr: 'CheckSecurityForNode')
    {"contentDocument", TestObjInternal::contentDocumentAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'mutablePoint' (Type: 'attribute' ExtAttr: '')
    {"mutablePoint", TestObjInternal::mutablePointAttrGetter, TestObjInternal::mutablePointAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'immutablePoint' (Type: 'attribute' ExtAttr: 'Immutable')
    {"immutablePoint", TestObjInternal::immutablePointAttrGetter, TestObjInternal::immutablePointAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'strictFloat' (Type: 'attribute' ExtAttr: 'StrictTypeChecking')
    {"strictFloat", TestObjInternal::strictFloatAttrGetter, TestObjInternal::strictFloatAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'description' (Type: 'readonly attribute' ExtAttr: '')
    {"description", TestObjInternal::descriptionAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'id' (Type: 'attribute' ExtAttr: '')
    {"id", TestObjInternal::idAttrGetter, TestObjInternal::idAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'hash' (Type: 'readonly attribute' ExtAttr: '')
    {"hash", TestObjInternal::hashAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
};

static const BatchedCallback TestObjCallbacks[] = {
    {"voidMethod", TestObjInternal::voidMethodCallback},
    {"intMethod", TestObjInternal::intMethodCallback},
    {"objMethod", TestObjInternal::objMethodCallback},
    {"serializedValue", TestObjInternal::serializedValueCallback},
    {"idbKey", TestObjInternal::idbKeyCallback},
    {"optionsObject", TestObjInternal::optionsObjectCallback},
    {"methodWithException", TestObjInternal::methodWithExceptionCallback},
    {"customMethod", V8TestObj::customMethodCallback},
    {"customMethodWithArgs", V8TestObj::customMethodWithArgsCallback},
    {"addEventListener", TestObjInternal::addEventListenerCallback},
    {"removeEventListener", TestObjInternal::removeEventListenerCallback},
    {"withScriptStateVoid", TestObjInternal::withScriptStateVoidCallback},
    {"withScriptStateObj", TestObjInternal::withScriptStateObjCallback},
    {"withScriptStateVoidException", TestObjInternal::withScriptStateVoidExceptionCallback},
    {"withScriptStateObjException", TestObjInternal::withScriptStateObjExceptionCallback},
    {"withScriptExecutionContext", TestObjInternal::withScriptExecutionContextCallback},
    {"withScriptExecutionContextAndScriptState", TestObjInternal::withScriptExecutionContextAndScriptStateCallback},
    {"withScriptExecutionContextAndScriptStateObjException", TestObjInternal::withScriptExecutionContextAndScriptStateObjExceptionCallback},
    {"withScriptExecutionContextAndScriptStateWithSpaces", TestObjInternal::withScriptExecutionContextAndScriptStateWithSpacesCallback},
    {"withScriptArgumentsAndCallStack", TestObjInternal::withScriptArgumentsAndCallStackCallback},
    {"methodWithOptionalArg", TestObjInternal::methodWithOptionalArgCallback},
    {"methodWithNonOptionalArgAndOptionalArg", TestObjInternal::methodWithNonOptionalArgAndOptionalArgCallback},
    {"methodWithNonOptionalArgAndTwoOptionalArgs", TestObjInternal::methodWithNonOptionalArgAndTwoOptionalArgsCallback},
    {"methodWithOptionalString", TestObjInternal::methodWithOptionalStringCallback},
    {"methodWithOptionalStringIsUndefined", TestObjInternal::methodWithOptionalStringIsUndefinedCallback},
    {"methodWithOptionalStringIsNullString", TestObjInternal::methodWithOptionalStringIsNullStringCallback},
    {"methodWithCallbackArg", TestObjInternal::methodWithCallbackArgCallback},
    {"methodWithNonCallbackArgAndCallbackArg", TestObjInternal::methodWithNonCallbackArgAndCallbackArgCallback},
    {"methodWithCallbackAndOptionalArg", TestObjInternal::methodWithCallbackAndOptionalArgCallback},
#if ENABLE(Condition1)
    {"conditionalMethod1", TestObjInternal::conditionalMethod1Callback},
#endif
#if ENABLE(Condition1) && ENABLE(Condition2)
    {"conditionalMethod2", TestObjInternal::conditionalMethod2Callback},
#endif
#if ENABLE(Condition1) || ENABLE(Condition2)
    {"conditionalMethod3", TestObjInternal::conditionalMethod3Callback},
#endif
    {"overloadedMethod", TestObjInternal::overloadedMethodCallback},
    {"getSVGDocument", TestObjInternal::getSVGDocumentCallback},
    {"mutablePointFunction", TestObjInternal::mutablePointFunctionCallback},
    {"immutablePointFunction", TestObjInternal::immutablePointFunctionCallback},
    {"orange", TestObjInternal::orangeCallback},
    {"strictFunction", TestObjInternal::strictFunctionCallback},
};

static const BatchedConstant TestObjConsts[] = {
#if ENABLE(Condition1)
    {"CONDITIONAL_CONST", static_cast<signed int>(0)},
#endif
    {"CONST_VALUE_0", static_cast<signed int>(0)},
    {"CONST_VALUE_1", static_cast<signed int>(1)},
    {"CONST_VALUE_2", static_cast<signed int>(2)},
    {"CONST_VALUE_4", static_cast<signed int>(4)},
    {"CONST_VALUE_8", static_cast<signed int>(8)},
    {"CONST_VALUE_9", static_cast<signed int>(-1)},
    {"CONST_VALUE_10", static_cast<signed int>("my constant string")},
    {"CONST_VALUE_11", static_cast<signed int>(0xffffffff)},
    {"CONST_VALUE_12", static_cast<signed int>(0x01)},
    {"CONST_VALUE_13", static_cast<signed int>(0X20)},
    {"CONST_VALUE_14", static_cast<signed int>(0x1abc)},
    {"CONST_JAVASCRIPT", static_cast<signed int>(15)},
};


#if ENABLE(Condition1)
COMPILE_ASSERT(0 == TestObj::CONDITIONAL_CONST, TestObjEnumCONDITIONAL_CONSTIsWrongUseDoNotCheckConstants);
#endif
COMPILE_ASSERT(0 == TestObj::CONST_VALUE_0, TestObjEnumCONST_VALUE_0IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == TestObj::CONST_VALUE_1, TestObjEnumCONST_VALUE_1IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == TestObj::CONST_VALUE_2, TestObjEnumCONST_VALUE_2IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == TestObj::CONST_VALUE_4, TestObjEnumCONST_VALUE_4IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == TestObj::CONST_VALUE_8, TestObjEnumCONST_VALUE_8IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(-1 == TestObj::CONST_VALUE_9, TestObjEnumCONST_VALUE_9IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT("my constant string" == TestObj::CONST_VALUE_10, TestObjEnumCONST_VALUE_10IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0xffffffff == TestObj::CONST_VALUE_11, TestObjEnumCONST_VALUE_11IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x01 == TestObj::CONST_VALUE_12, TestObjEnumCONST_VALUE_12IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0X20 == TestObj::CONST_VALUE_13, TestObjEnumCONST_VALUE_13IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x1abc == TestObj::CONST_VALUE_14, TestObjEnumCONST_VALUE_14IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(15 == TestObj::CONST_IMPL, TestObjEnumCONST_IMPLIsWrongUseDoNotCheckConstants);

v8::Handle<v8::Value> V8TestObj::constructorCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.Constructor");

    if (!args.IsConstructCall())
        return throwError("DOM object constructor cannot be called as a function.", V8Proxy::TypeError);

    if (ConstructorMode::current() == ConstructorMode::WrapExistingObject)
        return args.Holder();

    RefPtr<TestObj> impl = TestObj::create();
    v8::Handle<v8::Object> wrapper = args.Holder();

    V8DOMWrapper::setDOMWrapper(wrapper, &info, impl.get());
    impl->ref();
    V8DOMWrapper::setJSWrapperForDOMObject(impl.get(), v8::Persistent<v8::Object>::New(wrapper));
    return args.Holder();
}

static v8::Persistent<v8::FunctionTemplate> ConfigureV8TestObjTemplate(v8::Persistent<v8::FunctionTemplate> desc)
{
    desc->ReadOnlyPrototype();

    v8::Local<v8::Signature> defaultSignature;
    defaultSignature = configureTemplate(desc, "TestObject", v8::Persistent<v8::FunctionTemplate>(), V8TestObj::internalFieldCount,
        TestObjAttrs, WTF_ARRAY_LENGTH(TestObjAttrs),
        TestObjCallbacks, WTF_ARRAY_LENGTH(TestObjCallbacks));
    UNUSED_PARAM(defaultSignature); // In some cases, it will not be used.
    desc->SetCallHandler(V8TestObj::constructorCallback);
    v8::Local<v8::ObjectTemplate> instance = desc->InstanceTemplate();
    v8::Local<v8::ObjectTemplate> proto = desc->PrototypeTemplate();
    UNUSED_PARAM(instance); // In some cases, it will not be used.
    UNUSED_PARAM(proto); // In some cases, it will not be used.
    
    if (RuntimeEnabledFeatures::enabledAtRuntimeAttr1Enabled()) {
        static const BatchedAttribute attrData =\
        // Attribute 'enabledAtRuntimeAttr1' (Type: 'attribute' ExtAttr: 'V8EnabledAtRuntime')
        {"enabledAtRuntimeAttr1", TestObjInternal::enabledAtRuntimeAttr1AttrGetter, TestObjInternal::enabledAtRuntimeAttr1AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        configureAttribute(instance, proto, attrData);
    }
    if (RuntimeEnabledFeatures::featureNameEnabled()) {
        static const BatchedAttribute attrData =\
        // Attribute 'enabledAtRuntimeAttr2' (Type: 'attribute' ExtAttr: 'V8EnabledAtRuntime')
        {"enabledAtRuntimeAttr2", TestObjInternal::enabledAtRuntimeAttr2AttrGetter, TestObjInternal::enabledAtRuntimeAttr2AttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        configureAttribute(instance, proto, attrData);
    }

    // Custom Signature 'voidMethodWithArgs'
    const int voidMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> voidMethodWithArgsArgv[voidMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> voidMethodWithArgsSignature = v8::Signature::New(desc, voidMethodWithArgsArgc, voidMethodWithArgsArgv);
    proto->Set(v8::String::New("voidMethodWithArgs"), v8::FunctionTemplate::New(TestObjInternal::voidMethodWithArgsCallback, v8::Handle<v8::Value>(), voidMethodWithArgsSignature));

    // Custom Signature 'intMethodWithArgs'
    const int intMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> intMethodWithArgsArgv[intMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> intMethodWithArgsSignature = v8::Signature::New(desc, intMethodWithArgsArgc, intMethodWithArgsArgv);
    proto->Set(v8::String::New("intMethodWithArgs"), v8::FunctionTemplate::New(TestObjInternal::intMethodWithArgsCallback, v8::Handle<v8::Value>(), intMethodWithArgsSignature));

    // Custom Signature 'objMethodWithArgs'
    const int objMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> objMethodWithArgsArgv[objMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> objMethodWithArgsSignature = v8::Signature::New(desc, objMethodWithArgsArgc, objMethodWithArgsArgv);
    proto->Set(v8::String::New("objMethodWithArgs"), v8::FunctionTemplate::New(TestObjInternal::objMethodWithArgsCallback, v8::Handle<v8::Value>(), objMethodWithArgsSignature));

    // Custom Signature 'methodThatRequiresAllArgsAndThrows'
    const int methodThatRequiresAllArgsAndThrowsArgc = 2;
    v8::Handle<v8::FunctionTemplate> methodThatRequiresAllArgsAndThrowsArgv[methodThatRequiresAllArgsAndThrowsArgc] = { v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> methodThatRequiresAllArgsAndThrowsSignature = v8::Signature::New(desc, methodThatRequiresAllArgsAndThrowsArgc, methodThatRequiresAllArgsAndThrowsArgv);
    proto->Set(v8::String::New("methodThatRequiresAllArgsAndThrows"), v8::FunctionTemplate::New(TestObjInternal::methodThatRequiresAllArgsAndThrowsCallback, v8::Handle<v8::Value>(), methodThatRequiresAllArgsAndThrowsSignature));
    desc->Set(v8::String::New("classMethod"), v8::FunctionTemplate::New(TestObjInternal::classMethodCallback, v8::Handle<v8::Value>(), v8::Local<v8::Signature>()));
    desc->Set(v8::String::New("classMethodWithOptional"), v8::FunctionTemplate::New(TestObjInternal::classMethodWithOptionalCallback, v8::Handle<v8::Value>(), v8::Local<v8::Signature>()));
    desc->Set(v8::String::New("classMethod2"), v8::FunctionTemplate::New(V8TestObj::classMethod2Callback, v8::Handle<v8::Value>(), v8::Local<v8::Signature>()));
#if ENABLE(Condition1)
    desc->Set(v8::String::New("overloadedMethod1"), v8::FunctionTemplate::New(TestObjInternal::overloadedMethod1Callback, v8::Handle<v8::Value>(), v8::Local<v8::Signature>()));
#endif // ENABLE(Condition1)
    if (RuntimeEnabledFeatures::enabledAtRuntimeMethod1Enabled())
        proto->Set(v8::String::New("enabledAtRuntimeMethod1"), v8::FunctionTemplate::New(TestObjInternal::enabledAtRuntimeMethod1Callback, v8::Handle<v8::Value>(), defaultSignature));
    if (RuntimeEnabledFeatures::featureNameEnabled())
        proto->Set(v8::String::New("enabledAtRuntimeMethod2"), v8::FunctionTemplate::New(TestObjInternal::enabledAtRuntimeMethod2Callback, v8::Handle<v8::Value>(), defaultSignature));

    // Custom Signature 'convert1'
    const int convert1Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert1Argv[convert1Argc] = { V8a::GetRawTemplate() };
    v8::Handle<v8::Signature> convert1Signature = v8::Signature::New(desc, convert1Argc, convert1Argv);
    proto->Set(v8::String::New("convert1"), v8::FunctionTemplate::New(TestObjInternal::convert1Callback, v8::Handle<v8::Value>(), convert1Signature));

    // Custom Signature 'convert2'
    const int convert2Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert2Argv[convert2Argc] = { V8b::GetRawTemplate() };
    v8::Handle<v8::Signature> convert2Signature = v8::Signature::New(desc, convert2Argc, convert2Argv);
    proto->Set(v8::String::New("convert2"), v8::FunctionTemplate::New(TestObjInternal::convert2Callback, v8::Handle<v8::Value>(), convert2Signature));

    // Custom Signature 'convert3'
    const int convert3Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert3Argv[convert3Argc] = { V8c::GetRawTemplate() };
    v8::Handle<v8::Signature> convert3Signature = v8::Signature::New(desc, convert3Argc, convert3Argv);
    proto->Set(v8::String::New("convert3"), v8::FunctionTemplate::New(TestObjInternal::convert3Callback, v8::Handle<v8::Value>(), convert3Signature));

    // Custom Signature 'convert4'
    const int convert4Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert4Argv[convert4Argc] = { V8d::GetRawTemplate() };
    v8::Handle<v8::Signature> convert4Signature = v8::Signature::New(desc, convert4Argc, convert4Argv);
    proto->Set(v8::String::New("convert4"), v8::FunctionTemplate::New(TestObjInternal::convert4Callback, v8::Handle<v8::Value>(), convert4Signature));

    // Custom Signature 'convert5'
    const int convert5Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert5Argv[convert5Argc] = { V8e::GetRawTemplate() };
    v8::Handle<v8::Signature> convert5Signature = v8::Signature::New(desc, convert5Argc, convert5Argv);
    proto->Set(v8::String::New("convert5"), v8::FunctionTemplate::New(TestObjInternal::convert5Callback, v8::Handle<v8::Value>(), convert5Signature));
    batchConfigureConstants(desc, proto, TestObjConsts, WTF_ARRAY_LENGTH(TestObjConsts));

    // Custom toString template
    desc->Set(getToStringName(), getToStringTemplate());
    return desc;
}

v8::Persistent<v8::FunctionTemplate> V8TestObj::GetRawTemplate()
{
    V8BindingPerIsolateData* data = V8BindingPerIsolateData::current();
    V8BindingPerIsolateData::TemplateMap::iterator result = data->rawTemplateMap().find(&info);
    if (result != data->rawTemplateMap().end())
        return result->second;

    v8::HandleScope handleScope;
    v8::Persistent<v8::FunctionTemplate> templ = createRawTemplate();
    data->rawTemplateMap().add(&info, templ);
    return templ;
}

v8::Persistent<v8::FunctionTemplate> V8TestObj::GetTemplate()
{
    V8BindingPerIsolateData* data = V8BindingPerIsolateData::current();
    V8BindingPerIsolateData::TemplateMap::iterator result = data->templateMap().find(&info);
    if (result != data->templateMap().end())
        return result->second;

    v8::HandleScope handleScope;
    v8::Persistent<v8::FunctionTemplate> templ =
        ConfigureV8TestObjTemplate(GetRawTemplate());
    data->templateMap().add(&info, templ);
    return templ;
}

bool V8TestObj::HasInstance(v8::Handle<v8::Value> value)
{
    return GetRawTemplate()->HasInstance(value);
}


v8::Handle<v8::Object> V8TestObj::wrapSlow(TestObj* impl)
{
    v8::Handle<v8::Object> wrapper;
    V8Proxy* proxy = 0;
    wrapper = V8DOMWrapper::instantiateV8Object(proxy, &info, impl);
    if (UNLIKELY(wrapper.IsEmpty()))
        return wrapper;

    impl->ref();
    v8::Persistent<v8::Object> wrapperHandle = v8::Persistent<v8::Object>::New(wrapper);

    if (!hasDependentLifetime)
        wrapperHandle.MarkIndependent();
    getDOMObjectMap().set(impl, wrapperHandle);
    return wrapper;
}

void V8TestObj::derefObject(void* object)
{
    static_cast<TestObj*>(object)->deref();
}

} // namespace WebCore
