/*
 * Copyright (C) 2008 Alp Toker <alp@atoker.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#include "config.h"
#include "FontCache.h"

#include "Font.h"
#include "OwnPtrCairo.h"
#include "SimpleFontData.h"
#include <wtf/Assertions.h>
#include <wtf/text/CString.h>
#include <fontconfig/fontconfig.h>

namespace WebCore {

void FontCache::platformInit()
{
#if 0 // TODO
    if (!FontPlatformData::init())
        ASSERT_NOT_REACHED();
#endif
}

const SimpleFontData* FontCache::getFontDataForCharacters(const Font& font, const UChar* characters, int length)
{
    return 0;
}

SimpleFontData* FontCache::getSimilarFontPlatformData(const Font& font)
{
    return 0;
}

static FcChar8* getFontFamilyFromStandardName(const char* standardName) {
	FcPattern *fcPattern;
	FcPattern *fcPatternMatched;
	FcPattern *fcPatternFilter;
	FcBool	retBool;
	FcFontSet*	fcFontSet;
	FcResult	fcResult;
	FcChar8*	fcFamily;

	fcPattern = FcNameParse((FcChar8 *)standardName);
	retBool = FcConfigSubstitute(NULL, fcPattern, FcMatchPattern);
	if(FcTrue == retBool) {
		FcDefaultSubstitute(fcPattern);
		fcFontSet = FcFontSetCreate();
		fcPatternMatched = FcFontMatch(NULL, fcPattern, &fcResult);
		FcFontSetAdd(fcFontSet, fcPatternMatched);
		FcPatternDestroy(fcPattern);

		fcPatternFilter = FcPatternFilter(fcPatternMatched, NULL);
		fcFamily = FcPatternFormat(fcPatternFilter, (FcChar8 *)"%{family}");
		FcPatternDestroy(fcPatternFilter);
		FcFontSetDestroy(fcFontSet);
	}
	else {
		// TODO: Error recovery;
		fcFamily = NULL;
	}
	return fcFamily;
}

SimpleFontData* FontCache::getLastResortFallbackFont(const FontDescription& fontDescription, ShouldRetain shouldRetain)
{
    // FIXME: Would be even better to somehow get the user's default font here.
    // For now we'll pick the default that the user would get without changing any prefs.
#if 1
    FcChar8* family = getFontFamilyFromStandardName("Times New Roman");
    static AtomicString timesStr = AtomicString::fromUTF8((const char*)family);
    FcStrFree(family);
    return getCachedFontData(fontDescription, timesStr, false, shouldRetain);
#else
	// TODO: use FontConfig
	// TODO: take "last resort" family
	const AtomicString fallbackFamily = fontDescription.family().family();
	return getCachedFontData(new FontPlatformData(fontDescription, fallbackFamily), shouldRetain);
#endif
}

void FontCache::getTraitsInFamily(const AtomicString& familyName, Vector<unsigned>& traitsMasks)
{
}

static inline bool isWhitespace(UChar c)
{
    return c == ' ' || c == '\n' || c == '\r' || c == '\t';
}

FontPlatformData* FontCache::createFontPlatformData(const FontDescription& fontDescription, const AtomicString& family)
{
    FcChar8* char8 = getFontFamilyFromStandardName(family.string().utf8().data());
    String matchFamily = String::fromUTF8((const char*)char8);
    FcStrFree(char8);
    matchFamily = matchFamily.lower().removeCharacters(isWhitespace);
    Vector<String> matchFamilies;
    matchFamily.split( ',' , matchFamilies );
    String originFamily = String::fromUTF8(family.string().utf8().data()).lower().removeCharacters(isWhitespace);

    if(matchFamily == originFamily){
      return new FontPlatformData(fontDescription, family);     
    }
    for( unsigned int i = 0; i < matchFamilies.size(); i++ ){
      if(matchFamilies[i] == originFamily){
        return new FontPlatformData(fontDescription, family);     
      }
    }
    return 0;
}

}
