/*** COPYRIGHT FUJITSU LIMITED 2015 ***/

#include "config.h"
#include "PangoUtilities.h"

#include <pango/pango.h>

PangoData gs_pangoData;

//#define FJIB_FT_BITMAP_TRACE

static FT_Bitmap* gs_pangoft2_view_surface = NULL;

static gpointer pangoft2_view_create_surface (int width,
                                              int height)
{
	FT_Bitmap *bitmap;

	bitmap = g_slice_new (FT_Bitmap);
	bitmap->width = width;
	bitmap->pitch = (bitmap->width + 3) & ~3;
	bitmap->rows = height;
	bitmap->buffer = (unsigned char*)g_malloc (bitmap->pitch * bitmap->rows);
	bitmap->num_grays = 256;
	bitmap->pixel_mode = ft_pixel_mode_grays;

	return bitmap;
}

static void pangoft2_view_init(FT_Bitmap* bitmap) {
	memset (bitmap->buffer, 0x00, bitmap->pitch * bitmap->rows);
}

static void pangoft2_view_destroy_surface (gpointer instance G_GNUC_UNUSED,
			                               gpointer surface)
{
    FT_Bitmap *bitmap = (FT_Bitmap *) surface;

    g_free (bitmap->buffer);
    g_slice_free (FT_Bitmap, bitmap);
}

FT_Bitmap* pangoft2_view_request(int width, int height) {
#ifdef FJIB_FT_BITMAP_TRACE
	static int s_growCount = 0;
#endif
	int new_width;
	int new_height;

	if(width == 0 && height == 0) {
#ifdef FJIB_FT_BITMAP_TRACE
		printf(" *** delete request\n");
#endif
		if(gs_pangoft2_view_surface) {
			pangoft2_view_destroy_surface(NULL /*UNUSED*/, gs_pangoft2_view_surface);
			gs_pangoft2_view_surface = NULL;
		}
	}
	else {
		if(gs_pangoft2_view_surface == NULL) {
			gs_pangoft2_view_surface = (FT_Bitmap *)pangoft2_view_create_surface(width, height);
		}
		else if(width > gs_pangoft2_view_surface->width || height > gs_pangoft2_view_surface->rows) {
#ifdef FJIB_FT_BITMAP_TRACE
			printf(" *** buffer grow up from: %d, %d\n", gs_pangoft2_view_surface->width,
				gs_pangoft2_view_surface->rows);
#endif
			new_width = (width > gs_pangoft2_view_surface->width) ? width + 16 : gs_pangoft2_view_surface->width;
			new_height = (height > gs_pangoft2_view_surface->rows) ? height + 16 : gs_pangoft2_view_surface->rows;

			pangoft2_view_destroy_surface(NULL /*UNUSED*/, gs_pangoft2_view_surface);
			gs_pangoft2_view_surface = (FT_Bitmap*)pangoft2_view_create_surface(new_width, new_height);
#ifdef FJIB_FT_BITMAP_TRACE
			printf(" *** [%04d]buffer grow up to: %d, %d\n", s_growCount, gs_pangoft2_view_surface->width,
				gs_pangoft2_view_surface->rows);
			s_growCount++;
#endif
		}
		pangoft2_view_init(gs_pangoft2_view_surface);
	}
	return gs_pangoft2_view_surface;
}

void initializePango() {
	if(PANGO_MAP_INSTANCE == NULL) {
		PANGO_MAP_INSTANCE = pango_ft2_font_map_new();
		PANGO_CONTEXT_INSTANCE = pango_font_map_create_context(PANGO_MAP_INSTANCE);
		pango_context_set_base_dir(PANGO_CONTEXT_INSTANCE, PANGO_DIRECTION_LTR);
		PANGO_LANGUAGE_INSTANCE = pango_language_get_default();
		pango_context_set_language(PANGO_CONTEXT_INSTANCE, PANGO_LANGUAGE_INSTANCE);
	}
}

void finalizePango() {
	if(PANGO_CONTEXT_INSTANCE) {
		g_object_unref(PANGO_CONTEXT_INSTANCE);
		PANGO_CONTEXT_INSTANCE = NULL;
	}

	if(PANGO_MAP_INSTANCE) {
		g_object_unref(PANGO_MAP_INSTANCE);
		PANGO_MAP_INSTANCE = NULL;
	}
}

