# -------------------------------------------------------------------
# Project file for the QtWebKit C++ APIs
#
# See 'Tools/qmake/README' for an overview of the build system
# -------------------------------------------------------------------

TEMPLATE = lib
TARGET = QtWebKit

WEBKIT_DESTDIR = $${ROOT_BUILD_DIR}/lib

INCLUDEPATH += \
	platform/graphics/pango \
	platform/graphics/cairo \

PKGCONFIG += pangoft2 pango

haveQt(5) {
    # Use Qt5's module system
    load(qt_module)
    MODULE = webkit
    MODULE_PRI = $$QT.webkit.module_pri
    CONFIG += module

    BASE_TARGET = $$TARGET

    load(qt_module_config)

    # Make sure the module config doesn't override our preferred build config
    debug_and_release:if(!debug|!release): CONFIG -= debug_and_release

    # Allow doing a debug-only build of WebKit (not supported by Qt)
    macx:!debug_and_release:debug: TARGET = $$BASE_TARGET

    # ---------------- Custom developer-build handling -------------------
    #
    # The assumption for Qt developer builds is that the module file
    # will be put into qtbase/mkspecs/modules, and the libraries into
    # qtbase/lib, with rpath/install_name set to the Qt lib dir.
    #
    # For WebKit we don't want that behavior for the libraries, as we want
    # them to be self-contained in the WebKit build dir. To achive that we
    # trick Qt into thinking it's not a developer build, but setting QTDIR
    # to a bogus path in default_pre.prf.
    #
    # We still want the module file to live in the Qt dir so the module can
    # be used by setting QT += webkit, so we copy the file manually. We also
    # have to make sure the rpath/install_name of the libraries are relative
    # to the webkit build dir.

    # We use private_tests to detect developer build, since the destdir will
    # always be our webkit build dir. This might change as configure changes.
    contains(QT_CONFIG, private_tests): CONFIG += qt_developer_build

    !build_pass {
        # Make a more accessible copy of the module forward file
        # in the WebKit build directory.
        convenience_module_path = $${ROOT_BUILD_DIR}/modules
        module_filename = $$basename(QT.webkit.module_pri)

        make_module_fwd_convenience.target = $$convenience_module_path/$$module_filename
        make_module_fwd_convenience.commands = $$QMAKE_MKDIR $$convenience_module_path \
            && echo \"include($$QMAKE_EXTRA_MODULE_FORWARDS/$$module_filename)\" > $$convenience_module_path/$$module_filename
        make_module_fwd_convenience.depends = $$QMAKE_EXTRA_MODULE_FORWARDS/$$module_filename

        QMAKE_EXTRA_TARGETS += make_module_fwd_convenience
        DEFAULT_TARGETS += make_module_fwd_convenience

        qt_developer_build {
            # Copy the module forward file into Qt so that the module
            # is immediately accessible.
            qt_modules_path = $$[QT_INSTALL_PREFIX]/mkspecs/modules

            copy_module_fwd_file.target = $$qt_modules_path/$$module_filename
            copy_module_fwd_file.commands = $$QMAKE_COPY $$QMAKE_EXTRA_MODULE_FORWARDS/$$module_filename $$qt_modules_path
            # FIXME: Add dependendy that ensures we copy the forward file if the target is updated
            copy_module_fwd_file.depends = $$QMAKE_EXTRA_MODULE_FORWARDS/$$module_filename

            QMAKE_EXTRA_TARGETS += copy_module_fwd_file
            DEFAULT_TARGETS += copy_module_fwd_file
        }
    }

    # Make sure the install_name of the QtWebKit library point to webkit
    macx {
        # We do our own absolute path so that we can trick qmake into
        # using the webkit build path instead of the Qt install path.
        CONFIG -= absolute_library_soname
        QMAKE_LFLAGS_SONAME = $$QMAKE_LFLAGS_SONAME$$WEBKIT_DESTDIR/

        !debug_and_release|build_pass {
            # We also have to make sure the install_name is correct when
            # the library is installed.
            change_install_name.depends = install_target

            # The install rules generated by qmake for frameworks are busted in
            # that both the debug and the release makefile copy QtWebKit.framework
            # into the install dir, so whatever changes we did to the release library
            # will get overwritten when the debug library is installed. We work around
            # that by running install_name on both, for both configs.
            change_install_name.commands = framework_dir=\$\$(dirname $(TARGETD)); \
                for file in \$\$(ls $$[QT_INSTALL_LIBS]/\$\$framework_dir/$$BASE_TARGET*); do \
                    install_name_tool -id \$\$file \$\$file; \
                done
            default_install_target.target = install
            default_install_target.depends += change_install_name

            QMAKE_EXTRA_TARGETS += change_install_name default_install_target
        }
    }
} else {
    DESTDIR = $$WEBKIT_DESTDIR
}

runSyncQt() # Generate forwarding headers for the QtWebKit API

load(features)

include(WebKit/WebKit.pri)

WEBKIT += wtf

!v8:WEBKIT += javascriptcore

WEBKIT += webcore

!no_webkit2 {
    WEBKIT += webkit2
    QT += declarative

    # Ensure that changes to the WebKit2 API will trigger a qmake of this
    # file, which in turn runs syncqt to update the forwarding headers.
    QMAKE_INTERNAL_INCLUDED_FILES *= WebKit2/Target.pri
}

QT += network
haveQt(5): QT += widgets printsupport quick

contains(DEFINES, WTF_USE_TEXTURE_MAPPER_GL=1)|contains(DEFINES, ENABLE_WEBGL=1) {
    QT *= opengl
    # Make sure OpenGL libs are after the webcore lib so MinGW can resolve symbols
    win32*:!win32-msvc*: LIBS += $$QMAKE_LIBS_OPENGL
}

!static: DEFINES += QT_MAKEDLL

SOURCES += \
    $$PWD/WebKit/qt/WebCoreSupport/QtFallbackWebPopup.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/QtWebComboBox.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/ChromeClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/ContextMenuClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/DragClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/DumpRenderTreeSupportQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/EditorClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/UndoStepQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/FrameLoaderClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/FrameNetworkingContextQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/GeolocationPermissionClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/InitWebCoreQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/InspectorClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/InspectorServerQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/NotificationPresenterClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/PageClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/PopupMenuQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/QtPlatformPlugin.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/RenderThemeQStyle.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/ScrollbarThemeQStyle.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/SearchPopupMenuQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/TextCheckerClientQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/PlatformStrategiesQt.cpp \
    $$PWD/WebKit/qt/WebCoreSupport/WebEventConversion.cpp

HEADERS += \
    $$PWD/WebKit/qt/WebCoreSupport/InitWebCoreQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/InspectorServerQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/QtFallbackWebPopup.h \
    $$PWD/WebKit/qt/WebCoreSupport/QtWebComboBox.h \
    $$PWD/WebKit/qt/WebCoreSupport/FrameLoaderClientQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/FrameNetworkingContextQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/GeolocationPermissionClientQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/NotificationPresenterClientQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/PageClientQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/PopupMenuQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/QtPlatformPlugin.h \
    $$PWD/WebKit/qt/WebCoreSupport/RenderThemeQStyle.h \
    $$PWD/WebKit/qt/WebCoreSupport/ScrollbarThemeQStyle.h \
    $$PWD/WebKit/qt/WebCoreSupport/SearchPopupMenuQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/TextCheckerClientQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/PlatformStrategiesQt.h \
    $$PWD/WebKit/qt/WebCoreSupport/WebEventConversion.h

INCLUDEPATH += \
    $$PWD/WebKit/qt/Api \
    $$PWD/WebKit/qt/WebCoreSupport

contains(DEFINES, ENABLE_VIDEO=1) {
    !contains(DEFINES, WTF_USE_QTKIT=1):!contains(DEFINES, WTF_USE_GSTREAMER=1):contains(DEFINES, WTF_USE_QT_MULTIMEDIA=1) {
        HEADERS += $$PWD/WebKit/qt/WebCoreSupport/FullScreenVideoWidget.h
        SOURCES += $$PWD/WebKit/qt/WebCoreSupport/FullScreenVideoWidget.cpp
    }

    contains(DEFINES, WTF_USE_QTKIT=1) | contains(DEFINES, WTF_USE_GSTREAMER=1) | contains(DEFINES, WTF_USE_QT_MULTIMEDIA=1) {
        HEADERS += $$PWD/WebKit/qt/WebCoreSupport/FullScreenVideoQt.h
        SOURCES += $$PWD/WebKit/qt/WebCoreSupport/FullScreenVideoQt.cpp
    }

    contains(DEFINES, WTF_USE_QTKIT=1) {
        INCLUDEPATH += \
            $$PWD/WebCore/platform/qt/ \
            $$PWD/WebCore/platform/mac/ \
            $$PWD/../WebKitLibraries/

        DEFINES += NSGEOMETRY_TYPES_SAME_AS_CGGEOMETRY_TYPES

        contains(CONFIG, "x86") {
            DEFINES+=NS_BUILD_32_LIKE_64
        }

        HEADERS += \
            $$PWD/WebKit/qt/WebCoreSupport/WebSystemInterface.h \
            $$PWD/WebKit/qt/WebCoreSupport/QTKitFullScreenVideoHandler.h

        OBJECTIVE_SOURCES += \
            $$PWD/WebKit/qt/WebCoreSupport/WebSystemInterface.mm \
            $$PWD/WebKit/qt/WebCoreSupport/QTKitFullScreenVideoHandler.mm

        LIBS += -framework Security -framework IOKit

        # We can know the Mac OS version by using the Darwin major version
        DARWIN_VERSION = $$split(QMAKE_HOST.version, ".")
        DARWIN_MAJOR_VERSION = $$first(DARWIN_VERSION)
        equals(DARWIN_MAJOR_VERSION, "11") {
            LIBS += $${ROOT_WEBKIT_DIR}/WebKitLibraries/libWebKitSystemInterfaceLion.a
        } else:equals(DARWIN_MAJOR_VERSION, "10") {
            LIBS += $${ROOT_WEBKIT_DIR}/WebKitLibraries/libWebKitSystemInterfaceSnowLeopard.a
        } else:equals(DARWIN_MAJOR_VERSION, "9") {
            LIBS += $${ROOT_WEBKIT_DIR}/WebKitLibraries/libWebKitSystemInterfaceLeopard.a
        }
    }
}

contains(DEFINES, ENABLE_ICONDATABASE=1) {
    HEADERS += \
        $$PWD/WebCore/loader/icon/IconDatabaseClient.h \
        $$PWD/WebKit/qt/WebCoreSupport/IconDatabaseClientQt.h

    SOURCES += \
        $$PWD/WebKit/qt/WebCoreSupport/IconDatabaseClientQt.cpp
}

contains(DEFINES, ENABLE_DEVICE_ORIENTATION=1) || contains(DEFINES, ENABLE_ORIENTATION_EVENTS=1) {
    haveQt(5): QT += sensors
}

contains(DEFINES, ENABLE_DEVICE_ORIENTATION=1) {
    HEADERS += \
        $$PWD/WebKit/qt/WebCoreSupport/DeviceMotionClientQt.h \
        $$PWD/WebKit/qt/WebCoreSupport/DeviceMotionProviderQt.h \
        $$PWD/WebKit/qt/WebCoreSupport/DeviceOrientationClientQt.h \
        $$PWD/WebKit/qt/WebCoreSupport/DeviceOrientationProviderQt.h

    SOURCES += \
        $$PWD/WebKit/qt/WebCoreSupport/DeviceMotionClientQt.cpp \
        $$PWD/WebKit/qt/WebCoreSupport/DeviceMotionProviderQt.cpp \
        $$PWD/WebKit/qt/WebCoreSupport/DeviceOrientationClientQt.cpp \
        $$PWD/WebKit/qt/WebCoreSupport/DeviceOrientationProviderQt.cpp
}

contains(DEFINES, ENABLE_GEOLOCATION=1) {
     haveQt(5): QT += location

     HEADERS += \
        $$PWD/WebKit/qt/WebCoreSupport/GeolocationClientQt.h \
        $$PWD/WebKit/qt/WebCoreSupport/GeolocationPositionSource.h \
        $$PWD/WebKit/qt/WebCoreSupport/qgeocoordinate.h \
        $$PWD/WebKit/qt/WebCoreSupport/qgeopositioninfo.h \
        $$PWD/WebKit/qt/WebCoreSupport/qmobilityglobal.h \
        $$PWD/WebKit/qt/WebCoreSupport/qlocationutils_p.h

     SOURCES += \
        $$PWD/WebKit/qt/WebCoreSupport/GeolocationClientQt.cpp \
	$$PWD/WebKit/qt/WebCoreSupport/GeolocationPositionSource.cpp \
        $$PWD/WebKit/qt/WebCoreSupport/qgeocoordinate.cpp \
        $$PWD/WebKit/qt/WebCoreSupport/qgeopositioninfo.cpp
}

contains(CONFIG, texmap) {
    DEFINES += WTF_USE_TEXTURE_MAPPER=1
}

plugin_backend_xlib: PKGCONFIG += x11

QMAKE_LFLAGS_NOUNDEF =

# ------------- Install rules -------------

haveQt(5) {
    # Install rules handled by Qt's module system
} else {
    # For Qt4 we have to set up install rules manually

    # Syncqt has already run at this point, so we can use headers.pri
    # as a basis for our install-rules
    HEADERS_PRI = $${ROOT_BUILD_DIR}/include/$${QT.webkit.name}/headers.pri
    !include($$HEADERS_PRI): error(Failed to resolve install headers)

    headers.files = $$SYNCQT.HEADER_FILES $$SYNCQT.HEADER_CLASSES
    !isEmpty(INSTALL_HEADERS): headers.path = $$INSTALL_HEADERS/$${TARGET}
    else: headers.path = $$[QT_INSTALL_HEADERS]/$${TARGET}
    INSTALLS += headers

    !isEmpty(INSTALL_LIBS): target.path = $$INSTALL_LIBS
    else: target.path = $$[QT_INSTALL_LIBS]
    INSTALLS += target

    equals(GNUCC_PREFIX, "arm-poky-linux-gnueabi") {	
        LIBS += -L$(MAKETOP)/usr/pn/lib -leombrw -lawp_wdm_if `pkg-config --libs alsa`
    }

    unix {
        CONFIG += create_pc create_prl
        QMAKE_PKGCONFIG_LIBDIR = $$target.path
        QMAKE_PKGCONFIG_INCDIR = $$headers.path
        QMAKE_PKGCONFIG_DESTDIR = pkgconfig
        lib_replace.match = $$re_escape($$DESTDIR)
        lib_replace.replace = $$[QT_INSTALL_LIBS]
        QMAKE_PKGCONFIG_INSTALL_REPLACE += lib_replace
    }

    mac {
        !static:contains(QT_CONFIG, qt_framework) {
            # Build QtWebKit as a framework, to match how Qt was built
            CONFIG += lib_bundle qt_no_framework_direct_includes qt_framework

            # For debug_and_release configs, only copy headers in release
            !debug_and_release|if(build_pass:CONFIG(release, debug|release)) {
                FRAMEWORK_HEADERS.version = Versions
                FRAMEWORK_HEADERS.files = $${headers.files}
                FRAMEWORK_HEADERS.path = Headers
                QMAKE_BUNDLE_DATA += FRAMEWORK_HEADERS
            }
        }

        QMAKE_LFLAGS_SONAME = "$${QMAKE_LFLAGS_SONAME}$${DESTDIR}$${QMAKE_DIR_SEP}"
    }
}

LIBS += -L${QTDIR}/plugins/platforms -lqpneom

